using System;
using System.Data;
using System.Collections.Generic;
using System.Text;

namespace CodeAttributeDemo
{
   [AttributeUsage(AttributeTargets.Property | AttributeTargets.Field)]
   class DataColumnAttribute : Attribute
   {
      private string columnName = "Kolumna";
      private System.Data.DbType dataType = DbType.String;

      public DataColumnAttribute()
      {
      }

      public DataColumnAttribute(string column, DbType dbtype)
      {
         columnName = column;
         dataType = dbtype;
      }

      public string ColumnName
      {
         get { return columnName; }
         set { columnName = value; }
      }

      public DbType DataType
      {
         get { return dataType; }
         set { dataType = value; }
      }
   }
}
